//---------------------------------------------------------------------------
// File: svr_resources.cs
//
// This file contains functions for quickly modifying resources through
// console functions.  It is not intended to be used elsewhere because
// it gives direct access to the server's resource stack.
//
// Author: Michael Felice
//---------------------------------------------------------------------------

function IncreaseAll(%amount)
{
   IncreaseExperience(%amount);
   IncreaseFoodMax(%amount);
   IncreaseFood(%amount);
   IncreaseGold(%amount);
   IncreaseHappiness(%amount);
   IncreaseWaterMax(%amount);
   IncreaseWater(%amount);
   IncreaseWood(%amount);
}

// increase experience
function IncreaseExperience(%amount)
{
   GameResourceStack.getResource().getExperience().increaseCount(%amount);
}

// increases gold
function IncreaseGold(%amount)
{
   %resource = GameResourceStack.getResource();
   %resource.clearHappinessRates();
   %resource.getGold().increaseCount(%amount);
}

// increases wood
function IncreaseWood(%amount)
{
   %resource = GameResourceStack.getResource();
   %resource.clearHappinessRates();
   %resource.getWood().increaseCount(%amount);
}

// increases water
function IncreaseWater(%amount)
{
   %resource = GameResourceStack.getResource();
   %resource.clearHappinessRates();
   %resource.getWater().increaseCount(%amount);
}

// increases food
function IncreaseFood(%amount)
{
   %resource = GameResourceStack.getResource();
   %resource.clearHappinessRates();
   %resource.getFood().increaseCount(%amount);
}

// increase happiness
function IncreaseHappiness(%amount)
{
   GameResourceStack.getResource().getHappiness().increaseCount(%amount);
}

// increases water
function IncreaseWaterMax(%amount)
{
   GameResourceStack.getResource().getWater().increaseMax(%amount);
}

// increases food max
function IncreaseFoodMax(%amount)
{
   GameResourceStack.getResource().getFood().increaseMax(%amount);
}

// decreases experience
function DecreaseExperience(%amount)
{
   GameResourceStack.getResource().getExperience().decreaseCount(%amount);
}

// decreases gold
function DecreaseGold(%amount)
{
   GameResourceStack.getResource().getGold().decreaseCount(%amount);
}

// decreases wood
function DecreaseWood(%amount)
{
   GameResourceStack.getResource().getWood().decreaseCount(%amount);
}

// decreases water
function DecreaseWater(%amount)
{
   GameResourceStack.getResource().getWater().decreaseCount(%amount);
}

// decreases food
function DecreaseFood(%amount)
{
   GameResourceStack.getResource().getFood().decreaseCount(%amount);
}

// decrease happiness
function DecreaseHappiness(%amount)
{
   GameResourceStack.getResource().getHappiness().decreaseCount(%amount);
}

// decreases water max
function DecreaseWaterMax(%amount)
{
   GameResourceStack.getResource().getWater().decreaseMax(%amount);
}

// decreases food max
function DecreaseFoodMax(%amount)
{
   GameResourceStack.getResource().getFood().decreaseMax(%amount);
}
